/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack;


import org.w3c.dom.Node;

import woolpack.dom.DomContext;

import junit.framework.TestCase;

public class TestUtilsTest extends TestCase {
	
	public void testPrint(){
		final DomContext context = new DomContext();
		TestUtils.getToNodeForm(
				"<!-- hoge -->" + 
				"<TEXTAREA name=\"name0\" >value0</TEXTAREA>").interpret(context);
		TestUtils.print(context);
	}
	
	private void scenario(final boolean expected, final String s0, final String s1){
		final DomContext context0 = new DomContext();
		TestUtils.getToNodeForm(s0).interpret(context0);
		
		final DomContext context1 = new DomContext();
		TestUtils.getToNodeForm(s1).interpret(context1);
		
		assertEquals(expected, TestUtils.equals(context0.getNode(), context1.getNode()));
		assertTrue(context0.getNode() != context1.getNode());
	}
	
	public void testDefferentDocument(){
		scenario(true, 
				"<!-- hoge -->" + 
				"<TEXTAREA name=\"name0\" >value0</TEXTAREA>",
				"<!-- hoge -->" + 
				"<TEXTAREA name=\"name0\" >value0</TEXTAREA>");
	}
	
	public void testAttrOrder(){
		scenario(true, 
				"<!-- hoge -->" + 
				"<TEXTAREA id=\"id0\" name=\"name0\" >value0</TEXTAREA>",
				"<!-- hoge -->" + 
				"<TEXTAREA name=\"name0\" id=\"id0\" >value0</TEXTAREA>");
	}
	
	public void testDefferentAttrValue(){
		scenario(false, 
				"<!-- hoge -->" + 
				"<TEXTAREA name=\"name0\" >value0</TEXTAREA>",
				"<!-- hoge -->" + 
				"<TEXTAREA name=\"name1\" >value0</TEXTAREA>");
	}
	
	public void testDefferentAttrRack(){
		scenario(false, 
				"<!-- hoge -->" + 
				"<TEXTAREA name=\"name0\" >value0</TEXTAREA>",
				"<!-- hoge -->" + 
				"<TEXTAREA >value0</TEXTAREA>");
	}
	
	public void testDefferentOption(){
		scenario(true, 
				"<!-- hoge -->" + 
				"<SELECT name=\"name0\" ><OPTION value=\"value0\" >label0</OPTION></SELECT>",
				"<!-- hoge -->" + 
				"<SELECT name=\"name0\" ><OPTION value=\"value0\" >label0</OPTION></SELECT>");
	}
	
	public void testDefferentChildRack(){
		scenario(false, 
				"<!-- hoge -->" + 
				"<SELECT name=\"name0\" ><OPTION value=\"value0\" >label0</OPTION></SELECT>",
				"<!-- hoge -->" + 
				"<SELECT name=\"name0\" ></SELECT>");
	}
	
	public void testDefferentAttrName(){
		scenario(false, 
				"<!-- hoge -->" + 
				"<TEXTAREA name=\"name0\" >value0</TEXTAREA>",
				"<!-- hoge -->" + 
				"<TEXTAREA namf=\"name0\" >value0</TEXTAREA>");
	}
	
	public void testDefferentText(){
		scenario(false, 
				"<!-- hoge -->" + 
				"<TEXTAREA name=\"name0\" >value0</TEXTAREA>",
				"<!-- hoge -->" + 
				"<TEXTAREA name=\"name0\" >value1</TEXTAREA>");
	}
	
	public void testDefferentComment(){
		scenario(false, 
				"<!-- hoge -->" + 
				"<TEXTAREA name=\"name0\" >value0</TEXTAREA>",
				"<!-- piyo -->" + 
				"<TEXTAREA name=\"name0\" >value0</TEXTAREA>");
	}
	
	public void testNull0(){
		final DomContext context = new DomContext();
		TestUtils.getToNodeForm(
				"<!-- hoge -->" + 
				"<TEXTAREA name=\"name0\" >value0</TEXTAREA>").interpret(context);
		
		assertTrue(TestUtils.equals((Node)null, null));
		assertFalse(TestUtils.equals((Node)null, context.getNode()));
		assertFalse(TestUtils.equals(context.getNode(), null));
	}

	public void testDefferentElementName(){
		scenario(false, 
				"<!-- hoge -->" + 
				"<SPAN>hoge</SPAN>",
				"<!-- hoge -->" + 
				"<DIV>hoge</DIV>");
	}

	public void testDefferentNodeType(){
		scenario(false, 
				"<!-- hoge -->" + 
				"hoge",
				"<!-- hoge -->" + 
				"<DIV>hoge</DIV>");
	}
}
