/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.Arrays;
import java.util.HashMap;

import junit.framework.TestCase;
import woolpack.TestUtils;
import woolpack.el.ArrayPathEL;
import woolpack.el.EL;
import woolpack.el.PathEL;
import woolpack.el.PropertyEL;
import woolpack.html.AutoUpdate;
import woolpack.utils.MapBuilder;

public class LoopTest extends TestCase {

	public void testConstructor(){
		try{
			new Loop(null, EL.NULL, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new Loop(EL.NULL, null, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new Loop(EL.NULL, EL.NULL, null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testCollection(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm(
						"<TABLE><TR id=\"iterate0\">" +
						"<TD><SPAN id=\"name0\">value0</SPAN></TD>" +
						"<TD><INPUT name=\"name1\" value=\"value1\" /></TD>" +
						"</TR></TABLE>"),
				new XPathAttrValue("id", "iterate0", new Loop(
						new ArrayPathEL(new PropertyEL("local"), new PropertyEL("list0")), 
						new PathEL("local.bean"), 
						new AutoUpdate(Arrays.asList("name", "id"), new PathEL("local.bean"))
				)));
		
		final DomContext context = new DomContext();
		context.getLocal().put("list0", Arrays.asList(
				MapBuilder.get(new HashMap<String,Object>()).put("name0", "embed00").put("name1", "embed01").get(), 
				MapBuilder.get(new HashMap<String,Object>()).put("name0", "embed10").put("name1", "embed11").get()
		));
		
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<TABLE>" +
				"<TR id=\"iterate0\">" +
				"<TD><SPAN id=\"name0\">embed00</SPAN></TD>" +
				"<TD><INPUT name=\"name1\" value=\"embed01\" /></TD>" +
				"</TR>" +
				"<TR id=\"iterate0\">" +
				"<TD><SPAN id=\"name0\">embed10</SPAN></TD>" +
				"<TD><INPUT name=\"name1\" value=\"embed11\" /></TD>" +
				"</TR>" +
				"</TABLE>"));
	}
	
	public void testArray(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm(
						"<TABLE><TR id=\"iterate0\">" +
						"<TD><SPAN id=\"name0\">value0</SPAN></TD>" +
						"<TD><INPUT name=\"name1\" value=\"value1\" /></TD>" +
						"</TR></TABLE>"),
				new XPathAttrValue("id", "iterate0", new Loop(
						new PathEL("local.list0"), 
						new PathEL("local.bean"), 
						new AutoUpdate(Arrays.asList("name", "id"), new PathEL("local.bean")))));
		
		final DomContext context = new DomContext();
		context.getLocal().put("list0", Arrays.asList(
				MapBuilder.get(new HashMap<String,Object>()).put("name0", "embed00").put("name1", "embed01").get(), 
				MapBuilder.get(new HashMap<String,Object>()).put("name0", "embed10").put("name1", "embed11").get()
		));
		
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<TABLE>" +
				"<TR id=\"iterate0\">" +
				"<TD><SPAN id=\"name0\">embed00</SPAN></TD>" +
				"<TD><INPUT name=\"name1\" value=\"embed01\" /></TD>" +
				"</TR>" +
				"<TR id=\"iterate0\">" +
				"<TD><SPAN id=\"name0\">embed10</SPAN></TD>" +
				"<TD><INPUT name=\"name1\" value=\"embed11\" /></TD>" +
				"</TR>" +
				"</TABLE>"));
	}
}
