/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import junit.framework.TestCase;
import woolpack.TestUtils;
import woolpack.el.EL;
import woolpack.el.FixEL;
import woolpack.el.PathEL;

public class UpdateAttrValueTest extends TestCase {

	public void testConstructor(){
		try{
			new UpdateAttrValue(null, EL.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new UpdateAttrValue("", EL.NULL);
			fail();
		}catch(final StringIndexOutOfBoundsException expected){
		}
		try{
			new UpdateAttrValue("value", null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"value0\" />"),
			new XPathAttrValue("name", "name0", new UpdateAttrValue("value", new FixEL("value1"))));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, "<INPUT type=\"text\" name=\"name0\" value=\"value1\" />"));
	}
	
	public void testTipsOGE(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"value0\" />"),
			new XPathAttrValue("name", "name0", new UpdateAttrValue("value", new PathEL("local.valueKey"))));
		final DomContext context = new DomContext();
		context.getLocal().put("valueKey", "value2");
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, "<INPUT type=\"text\" name=\"name0\" value=\"value2\" />"));
	}
}
