/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;

public class MapBuilderTest extends TestCase {
	
	public void testConstructor(){
		try{
			MapBuilder.get(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testNormal(){
		final MapBuilder<String,Integer> builder = MapBuilder.get(new HashMap<String,Integer>());
		
		assertEquals(builder, builder.put("key0", 5));
		assertEquals(builder, builder.put("key1"));
		assertEquals(builder, builder.put("key1", 7));
		assertEquals(builder, builder.put("key2", 7));

		final Map<String,Integer> expected = new HashMap<String,Integer>();
		expected.put("key0", new Integer(5));
		expected.put("key1", new Integer(7));
		expected.put("key2", new Integer(7));
		assertEquals(expected, builder.get());
	}
}
