/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

import junit.framework.TestCase;

public class RegExpIdValidatorTest extends TestCase {

	public void testConstructor(){
		try{
			new RegExpIdValidator((Pattern)null);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new RegExpIdValidator((String)null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testMatch(){
		final ValidatorExpression expression = new RegExpIdValidator("a[0-9]");
		final ValidatorContext context = new ValidatorContext();
		
		context.setId("a4");
		assertFalse(expression.interpret(context));

		context.setId("aa");
		assertTrue(expression.interpret(context));
		
		try{
			context.setId(null);
			expression.interpret(context);
			fail();
		}catch(final NullPointerException e){
			assertNull(context.getId());
		}
	}
	
	public void testAppendTo() throws IOException{
		final ValidatorExpression expression = new RegExpIdValidator("a[0-9]");
		final StringBuilder sb = new StringBuilder();
		expression.appendTo(sb);
		assertEquals("new RegExpIdValidator(\"a[0-9]\")", sb.toString());
	}
	
	public void testAddMessageTo(){
		final ValidatorExpression expression = new RegExpIdValidator("a[0-9]");
		final Collection<String> expectedCollection = new ArrayList<String>();
		expression.addMessageTo(expectedCollection);
		assertTrue(expectedCollection.isEmpty());
	}
}
