/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import junit.framework.TestCase;

public class SerialValidatorTest extends TestCase {

	public void testConstructor(){
		try{
			new SerialValidator((ValidatorIterable)null, ValidatorConstants.FALSE);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new SerialValidator(ValidatorConstants.AND, (Iterable<ValidatorExpression>)null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testAndFalseTrue(){
		final CountValidator counter0 = new CountValidator(ValidatorConstants.FALSE);
		final CountValidator counter1 = new CountValidator(ValidatorConstants.TRUE);
		final ValidatorExpression expression = new SerialValidator(ValidatorConstants.AND, counter0, counter1);
		final ValidatorContext context = new ValidatorContext();
		assertFalse(expression.interpret(context));
		assertEquals(1, counter0.getIntepretCount());
		assertEquals(1, counter1.getIntepretCount());
		assertTrue(context == counter0.getContextList().getLast());
		assertTrue(context == counter1.getContextList().getLast());
	}
	
	public void testAppendTo() throws IOException{
		final CountValidator counter0 = new CountValidator(ValidatorConstants.FALSE);
		final CountValidator counter1 = new CountValidator(ValidatorConstants.TRUE);
		final ValidatorExpression expression = new SerialValidator(ValidatorConstants.AND, counter0, counter1);
		final StringBuilder sb = new StringBuilder();
		expression.appendTo(sb);
		assertEquals("new SerialValidator(new AndValidatorIterable(),[new FalseValidator(),new TrueValidator()])", sb.toString());
		assertEquals(1, counter0.getAppendToCount());
		assertEquals(1, counter1.getAppendToCount());
		assertTrue(sb == counter0.getSbList().getLast());
		assertTrue(sb == counter1.getSbList().getLast());
	}
	
	public void testAddMessageTo(){
		final CountValidator counter0 = new CountValidator(ValidatorConstants.FALSE);
		final ValidatorExpression expression = new SerialValidator(ValidatorConstants.AND, counter0);
		final Collection<String> expectedCollection = new ArrayList<String>();
		expression.addMessageTo(expectedCollection);
		assertEquals(1, counter0.getAddMessageToCount());
		assertTrue(expectedCollection == counter0.getCollectionList().getLast());
	}

	public void testAndAndArray(){
		final CountValidator counter0 = new CountValidator(ValidatorConstants.TRUE);
		final CountValidator counter1 = new CountValidator(ValidatorConstants.TRUE);
		final ValidatorExpression expression = new SerialValidator(counter0, counter1);
		final ValidatorContext context = new ValidatorContext();
		assertTrue(expression.interpret(context));
		assertEquals(1, counter0.getIntepretCount());
		assertEquals(1, counter1.getIntepretCount());
		assertTrue(context == counter0.getContextList().getLast());
		assertTrue(context == counter1.getContextList().getLast());
	}

	public void testAndAndList(){
		final CountValidator counter0 = new CountValidator(ValidatorConstants.TRUE);
		final CountValidator counter1 = new CountValidator(ValidatorConstants.TRUE);
		final ValidatorExpression expression = new SerialValidator(Arrays.asList(counter0, counter1));
		final ValidatorContext context = new ValidatorContext();
		assertTrue(expression.interpret(context));
		assertEquals(1, counter0.getIntepretCount());
		assertEquals(1, counter1.getIntepretCount());
		assertTrue(context == counter0.getContextList().getLast());
		assertTrue(context == counter1.getContextList().getLast());
	}
}
