/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;

public class Sleep
implements DomExpression {
    private final long beforeMillis;
    private final long afterMillis;
    private final DomExpression expression;

    public Sleep(long beforeMillis, long afterMillis, DomExpression expression) {
        expression.getClass();
        this.beforeMillis = beforeMillis;
        this.afterMillis = afterMillis;
        this.expression = expression;
    }

    public void interpret(DomContext context) {
        if (this.beforeMillis > 0L) {
            try {
                Thread.sleep(this.beforeMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        this.expression.interpret(context);
        if (this.afterMillis > 0L) {
            try {
                Thread.sleep(this.afterMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

