/*
 * Decompiled with CFR 0.152.
 */
package woolpack.ee;

import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionClearBuilder {
    public static final String SESSION_ID_KEY = "woolpack.ee.SESSION_CLEAR_ID";
    public static final String NAME_KEY = "woolpack.ee.SESSION_CLEAR_NAME";
    public static final String REMOVER_KEY = "woolpack.ee.SESSION_CLEAR_REMOVER";
    private final String sessionIdKey;
    private final String nameKey;
    private final String removerKey;
    private final Map<String, String> sessionIdNameMap;
    private final Set<String> clearSessionIdSet;

    public SessionClearBuilder(String sessionIdKey, String nameKey, String removerKey, Map<String, String> sessionIdNameMap, Set<String> clearSessionIdSet) {
        sessionIdKey.charAt(0);
        nameKey.charAt(0);
        removerKey.charAt(0);
        sessionIdNameMap.getClass();
        clearSessionIdSet.getClass();
        this.sessionIdKey = sessionIdKey;
        this.nameKey = nameKey;
        this.removerKey = removerKey;
        this.sessionIdNameMap = sessionIdNameMap;
        this.clearSessionIdSet = clearSessionIdSet;
    }

    public SessionClearBuilder(Map<String, String> sessionIdNameMap, Set<String> clearSessionIdSet) {
        this(SESSION_ID_KEY, NAME_KEY, REMOVER_KEY, sessionIdNameMap, clearSessionIdSet);
    }

    public DomExpression getInitExpression() {
        return new DomExpression(){

            public void interpret(DomContext context) {
                final String sessionId = (String)context.getSession().get(SessionClearBuilder.this.sessionIdKey);
                final String name = (String)context.getSession().get(SessionClearBuilder.this.nameKey);
                if (sessionId != null && name != null && !context.getSession().containsKey(SessionClearBuilder.this.removerKey)) {
                    HttpSessionBindingListener o = new HttpSessionBindingListener(){

                        public void valueBound(HttpSessionBindingEvent arg0) {
                            SessionClearBuilder.this.sessionIdNameMap.put(sessionId, name);
                        }

                        public void valueUnbound(HttpSessionBindingEvent arg0) {
                            SessionClearBuilder.this.clearSessionIdSet.remove(sessionId);
                            SessionClearBuilder.this.sessionIdNameMap.remove(sessionId);
                        }
                    };
                    context.getSession().putIfAbsent(SessionClearBuilder.this.removerKey, o);
                }
            }
        };
    }

    public DomExpression getClearExpression() {
        return new DomExpression(){

            public void interpret(DomContext context) {
                String sessionId = (String)context.getSession().get(SessionClearBuilder.this.sessionIdKey);
                if (SessionClearBuilder.this.clearSessionIdSet.contains(sessionId)) {
                    context.getSession().clear();
                }
            }
        };
    }
}

