/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

// woolpackdoc.js

function convertAll(xpath, targetFunction){
var root = document.documentElement;
var resolver  = document.createNSResolver(root);
var expression= document.createExpression(xpath, resolver);
var result = expression.evaluate(root, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
for(var i=0; i<result.snapshotLength; i++){
	targetFunction(result.snapshotItem(i));
}
}

function convertLink(element){
var s = element.innerHTML;
s = s.replace(/^<!\[CDATA\[/, "");
s = s.replace(/\]\]>$/, "");
element.innerHTML = "<a href=\"" + s + "\">" + s + "</a>";
}

function convertSource(element){
var s = element.innerHTML;
//s = s.replace(/^<!--\[CDATA\[/, "");
//s = s.replace(/\]\]-->$/, "");
s = s.replace(/^<!\[CDATA\[/, "");
s = s.replace(/\]\]>$/, "");
//s = s.replace(/^<!--/, "");
//s = s.replace(/-->$/, "");
s = s.replace(/^\n+/, "");
s = s.replace(/\n+$/, "");
s = s.replace(/&/g, "&amp;");
s = s.replace(/\"/g, "&quot;");
s = s.replace(/</g, "&lt;");
s = s.replace(/>/g, "&gt;");
s = s.replace(/\t/g, "&#160;&#160;");
s = s.replace(/\n/g, "<br/>\n");
element.innerHTML = s;
}


function convertRenrakusaki(element){
var s0 = element.innerHTML;
s0 = s0.replace(/^<!\[CDATA\[/, "");
s0 = s0.replace(/\]\]>$/, "");
var s2 = "";
for(var i=0; i<s0.length; i=i+2){
	s2 = s2 + s0.charAt(i);
}
element.innerHTML = s2;
}

//function convertRowIndex(element){
//element.innerHTML = element.parentNode.parentNode.rowIndex;
//}

function convertInsertRowIndex(element){
var trList = element.getElementsByTagName("tr");
for(var i = 0; i<trList.length; i++){
	var s = (i==0)?'#':'' + i;
	trList[i].insertCell(0).appendChild(document.createTextNode(s));
}
}

function convertInsertLineNumber(element){
var trList = element.getElementsByTagName("tr");
if(trList.length < 1){
	return;
}
var count = 0;
{
	var tdList = element.getElementsByTagName("td");
	if(tdList.length < 1){
		return;
	}
	var text = tdList[0].innerHTML;
	var i = 0;
	while(true){
		i = text.indexOf("<br/>", i);
		if(i<0){
			break;
		}
		count++;
		i++;
	}
}
var lineNumbers = "";
for(var i=0; i<count+1; i++){
	lineNumbers = lineNumbers + (i+1) + "<br/>";
}
var insertedCell = trList[0].insertCell(0);
insertedCell.innerHTML = lineNumbers;
insertedCell.setAttribute("valign", "top");
}
