/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.Collection;

/**
 * {@link DomContext#getId()}が id 一覧に含まれることを検証した結果を返す{@link Evaluable}。
 * 画面遷移を自動生成する際の脆弱性を排除するために使用することを想定している。
 * @author nakamura
 *
 */
public class EvalIdContains implements Evaluable<Boolean> {
	private final Collection collection;
	
	/**
	 * コンストラクタ。
	 * @param collection id の一覧。本クラスはこの引数の状態を変化させない。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public EvalIdContains(final Collection collection){
		collection.getClass();
		this.collection = collection;
	}

	public Boolean eval(final DomContext context) {
		return collection.contains(context.getId());
	}
}
