/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import java.util.HashMap;
import java.util.Map;

/**
 * プロパティの出現回数をカウントするカウンタ。
 * @author nakamura
 *
 */
public class PropertyCounter {
	private final Map<String,Integer> map;
	private String name;
	private String value;
	
	public PropertyCounter(){
		map = new HashMap<String,Integer>();
		name = null;
		value = null;
	}
	
	/**
	 * プロパティの出現回数をひとつ増やして返す。
	 * @param name プロパティ名。
	 * @param value プロパティ値。
	 * @return プロパティの出現回数をひとつ増やした値。
	 */
	public int put(final String name, final String value){
		this.name = name;
		this.value = value;
		final Integer i = map.get(value);
		if(i == null){
			map.put(value, 1);
		}else{
			map.put(value, i+1);
		}
		return map.get(value);
	}
	
	/**
	 * プロパティの出現回数を返す。
	 * @param value プロパティ名。
	 * @return プロパティの出現回数。
	 */
	public int getCount(final String value){
		final Integer i = map.get(value);
		if(i == null){
			return 0;
		}
		return i;
	}
	
	/**
	 * 一時プロパティの出現回数を返す。
	 * @return プロパティの出現回数。
	 */
	public int getCount(){
		return getCount(value);
	}
	
	/**
	 * 一時プロパティ名を返す。
	 * @return プロパティ名。
	 */
	public String getName(){
		return name;
	}
	
	/**
	 * 一時プロパティ値を返す。
	 * @return プロパティ値。
	 */
	public String getValue(){
		return value;
	}
}
