/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.test;

import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;

/**
 * {@link DomExpression}に委譲する{@link Runnable}。
 * 適用しているパターン：Adapter。
 * @author nakamura
 *
 */
public class DomExpressionRunnable implements Runnable {
	private final DomExpression expression;
	private final DomContext context;
	
	/**
	 * コンストラクタ。
	 * @param expression 委譲先。
	 * @param context 委譲先に渡すコンテキスト。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 */
	public DomExpressionRunnable(final DomExpression expression, final DomContext context){
		expression.getClass();
		context.getClass();
		
		this.expression = expression;
		this.context = context;
	}

	public void run() {
		expression.interpret(context);
	}
}
