/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Date;

/**
 * 日付フォーマット処理を委譲する変換器。
 * @author nakamura
 *
 */
public class DelegateDateFormat extends DateFormat {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private DateFormat format;
	
	/**
	 * コピーコンストラクタ。
	 * {@link #clone()}から呼び出される(called)。
	 * @param format コピー元。
	 * @param dummy ダミー。
	 */
	protected DelegateDateFormat(final DelegateDateFormat format, boolean dummy){
		this.format = format.format;
	}
	
	/**
	 * コンストラクタ。
	 * @param format 委譲先。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public DelegateDateFormat(final DateFormat format){
		format.getClass();
		this.format = format;
	}

	@Override
	public StringBuffer format(Date date, StringBuffer toAppendTo,
			FieldPosition fieldPosition) {
		return format.format(date, toAppendTo, fieldPosition);
	}

	@Override
	public Date parse(String source, ParsePosition pos) {
		return format.parse(source, pos);
	}
	
	// 定義しないとDateFormatでNullPointerExceptionが発生する
	@Override public int hashCode(){
		return format.hashCode();
	}

	@Override public Object clone(){
		return new DelegateDateFormat(this, false);
	}

	public DateFormat getFormat() {
		return format;
	}
}
