/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

/**
 * 固定の値にフォーマットする変換器。
 * @author nakamura
 *
 */
public class FixFormat extends Format {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private final String value;
	
	/**
	 * コピーコンストラクタ。
	 * {@link #clone()}から呼び出される(called)。
	 * @param format コピー元。
	 */
	protected FixFormat(final FixFormat format){
		this.value = format.value;
	}
	
	/**
	 * コンストラクタ。
	 * @param value 固定値。
	 * @throws NullPointerException 引数が null の場合。
	 * @throws NullPointerException 引数が空の場合。
	 */
	public FixFormat(final String value){
		value.charAt(0);
		this.value = value;
	}

	@Override
	public StringBuffer format(final Object obj, final StringBuffer toAppendTo,
			final FieldPosition pos) {
		final int start = toAppendTo.length();
		toAppendTo.append(value);
		pos.setBeginIndex(start);
		pos.setEndIndex(toAppendTo.length());
		return toAppendTo;
	}

	@Override
	public Object parseObject(final String source, final ParsePosition pos) {
		pos.setIndex(value.length());
		return value;
	}

	@Override public Object clone(){
		return new FixFormat(this);
	}
	
	/**
	 * JavaScriptのコンストラクタ表現を返す。
	 */
	@Override public String toString(){
		final StringBuilder sb = new StringBuilder();
		sb.append("new FixFormat(");
//		if(value != null){
			sb.append('\"');
			sb.append(value);
			sb.append('\"');
//		}
		sb.append(')');
		return sb.toString();
	}

	public String getValue() {
		return value;
	}
}
