/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;

/**
 * 文字列を解析して{@link BigDecimal}に変換する変換器。
 * @author nakamura
 *
 */
public class ToBigDecimalFormat extends DelegateNumberFormat {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * コピーコンストラクタ。
	 * {@link #clone()}から呼び出される(called)。
	 * @param format コピー元。
	 * @param dummy ダミー。
	 */
	protected ToBigDecimalFormat(final ToBigDecimalFormat format, final boolean dummy){
		super(format, dummy);
	}
	
	/**
	 * コンストラクタ。
	 * @param format 数値変換の委譲先。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public ToBigDecimalFormat(final NumberFormat format){
		super(format);
	}

	/**
	 * コンストラクタ。
	 * {@link DecimalFormat}を数値変換の委譲先とする。
	 */
	public ToBigDecimalFormat(){
		super(TextConstants.getToBigDecimalFormat());
	}

	@Override
	public Number parse(final String source, final ParsePosition parsePosition) {
		final Number n = super.parse(source, parsePosition);
		if(n instanceof BigDecimal){
			return n;
		}else if(n instanceof Long){
			return new BigDecimal(n.longValue());
		}else if(n != null){
			return new BigDecimal(n.doubleValue());
		}
		return null;
	}

	@Override public Object clone(){
		return new ToBigDecimalFormat(this, false);
	}
}
