/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.util.ArrayList;
import java.util.List;

/**
 * 呼び出された順に{@link AddressedMessage}を生成し格納する{@link MessageCollectable}。
 * 本クラスはリクエストごとに生成することを想定している。
 * @author nakamura
 *
 */
public class AddressedMessageCollector implements MessageCollectable {
	private final List<AddressedMessage> list;
	
	/**
	 * コンストラクタ。
	 */
	public AddressedMessageCollector(){
		this.list = new ArrayList<AddressedMessage>();
	}

	public void add(final String message, final ValidatorContext context) {
		final AddressedMessage m = new AddressedMessage();
		m.setKey(context.getTmpKey());
		m.setIndex(context.getTmpIndex());
		m.setMessage(message);
		m.setValue(context.getTmpValue());
		list.add(m);
	}
	
	/**
	 * メッセージ一覧を返す。
	 * @return メッセージ一覧。
	 */
	public List<AddressedMessage> getList(){
		return list;
	}
}
