/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;


/**
 * 
 * 値検証と値変換をすることが可能であることを表す。
 * 実装クラスのコンストラクタツリーは複数のスレッド/複数の J2EE セッションから同時に実行されることを想定しているため
 * イミュータブルである必要がある。
 * 適用しているパターン：Interpreter(Expression 役)。
 * @author nakamura
 *
 */
public interface ValidatorExpression {

	/**
	 * 値検証を実行するために呼び出される(called)。
	 * 実装クラスでは引数が null でないことを前提としてよい。
	 * 実装クラスで{@link RuntimeException}のサブ例外が発生する場合は JavaDoc コメントに記載すると部品の可用性が維持される。
	 * @param context コンテキスト。
	 * @return 値検証結果。
	 */
	public boolean interpret(ValidatorContext context);
}
