/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.visitor;

import java.util.ArrayList;
import java.util.List;

/**
 * {@link #accept(Visitor, Object)}の Element 役の引数を記録する{@link Acceptable}。
 * @author nakamura
 *
 * @param <V>
 */
public class CountAcceptor<V> implements Acceptable<V> {
	private final List<V> list;
	
	/**
	 * コンストラクタ。
	 *
	 */
	public CountAcceptor(){
		list = new ArrayList<V>();
	}

	public void accept(final Visitor visitor, final V v) {
		list.add(v);
	}
	
	/**
	 * {@link #accept(Visitor, Object)}が呼び出された順に、その引数のElement 役の一覧を返す。
	 * @return Element 役の一覧。
	 */
	public List<V> getList(){
		return list;
	}
}
