/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.visitor.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import woolpack.utils.MapBuilder;
import woolpack.utils.Switchable;
import woolpack.validator.MessageValidator;
import woolpack.validator.ValidatorExpression;
import woolpack.visitor.Acceptable;
import woolpack.visitor.Visitor;
import woolpack.visitor.VisitorConstants;

/**
 * 値検証/値変換のコンストラクタツリーに含まれるメッセージを収集するための
 * 定数の集まり。
 * @author nakamura
 *
 */
public class MessageConstants {

	/**
	 * {@link Visitor#getContext()}を{@link Collection}にキャストして、
	 * {@link MessageValidator#getMessage()}を追加する{@link Acceptable}。
	 */
	public static final Acceptable<MessageValidator> ACCEPT_MessageValidator = new Acceptable<MessageValidator>(){
		public void accept(final Visitor visitor, final MessageValidator v) {
			((Collection<String>)visitor.getContext()).add(v.getMessage());
		}
	};
	/**
	 * 値検証/値変換に関するコンストラクタツリーに含まれる
	 * {@link MessageValidator#getMessage()}を収集するための、
	 * {@link Visitor#setMap(Map)}に設定する{@link Map}。
	 */
	public static final Map<Object,Acceptable> MAP = Collections.unmodifiableMap(MapBuilder.get(new LinkedHashMap<Object,Acceptable>())
			.put(MessageValidator.class, ACCEPT_MessageValidator)
			.put(ValidatorExpression.class, VisitorConstants.REFLECTION)
			.put(Iterable.class, VisitorConstants.ITERABLE)
			.put(Switchable.class, VisitorConstants.switchableAcceptable("defaultKey"))
			.put(Object.class, VisitorConstants.NULL)
			.get());

	private MessageConstants(){}// カバレージがここを通過してはいけない
}
