/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.adapter;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;
import ognl.TypeConverter;
import woolpack.el.convert.FixConverter;

public class ConvertableTypeConverterTest extends TestCase {

	public void testConstructor(){
		try{
			new ConvertableTypeConverter(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testNormal(){
		final TypeConverter converter = new ConvertableTypeConverter(new FixConverter("1"));
		
		final Map<String,Object> map = new HashMap<String,Object>();
		map.put("key0", 0);
		map.put("key1", 1);
		
		assertEquals("1", new OGE("key0", converter).getValue(map, String.class));
		assertEquals("1", new OGE("key1", converter).getValue(map, String.class));
		assertEquals("1", new OGE("key1", converter).getValue(map, BigDecimal.class));
		assertEquals("1", new OGE("key0", converter).getValue(map, BigDecimal.class));
	}
}
