/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import junit.framework.TestCase;

public class ConfigSerialTest extends TestCase {

	public void testConstructor(){
		try{
			new ConfigSerial((Iterable<ConfigExpression>)null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final ConfigCount[] counters = {new ConfigCount(ConfigConstants.NULL), new ConfigCount(ConfigConstants.NULL), new ConfigCount(ConfigConstants.NULL)};
		final ConfigExpression expression = new ConfigSerial((ConfigExpression[])counters);
		for(int i=0; i<counters.length; i++){
			assertEquals(0, counters[i].getCount());
		}
		{
			final ConfigContext context = new ConfigContext();
			expression.interpret(context);
			for(int i=0; i<counters.length; i++){
				assertEquals(1, counters[i].getCount());
				assertTrue(context == counters[i].getContextList().getLast());
			}
		}
		{
			final ConfigContext context = new ConfigContext();
			expression.interpret(context);
			for(int i=0; i<counters.length; i++){
				assertEquals(2, counters[i].getCount());
				assertTrue(context == counters[i].getContextList().getLast());
			}
		}
	}
}
