/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import junit.framework.TestCase;

public class DelegateDomExpressionTest extends TestCase {
	
	public void testNull(){
		final DelegateDomExpression expression = new DelegateDomExpression();
		try{
			expression.interpret(null);
		}catch(NullPointerException expected){
		}
	}

	public void testNormal(){
		final Count counter0 = new Count(DomConstants.NULL);
		final DelegateDomExpression expression = new DelegateDomExpression();
		expression.setExpression(counter0);
		assertEquals(counter0, expression.getExpression());
		assertEquals(0, counter0.getCount());
		final DomContext context = new DomContext();
		expression.interpret(context);
		assertEquals(1, counter0.getCount());
		assertTrue(context == counter0.getContextList().getLast());
	}
}
