/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.text.Format;

import junit.framework.TestCase;
import woolpack.adapter.JXP;
import woolpack.test.TestUtils;
import woolpack.text.FormatFactory;
import woolpack.text.RegExpFormat;

public class FormatAttrValueTest extends TestCase {

	public void testConstructor(){
		try{
			new FormatAttrValue(null, new RegExpFormat("a", "b"));
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new FormatAttrValue("", new RegExpFormat("a", "b"));
			fail();
		}catch(final StringIndexOutOfBoundsException expected){
		}
		try{
			new FormatAttrValue("attr", (FormatFactory)null);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new FormatAttrValue("attr", (Format)null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"value0\" />"),
				new XPath(new JXP("name", "name0"), new FormatAttrValue("value", new RegExpFormat("value([\\d])", "v$1v"))));
			final DomContext context = new DomContext();
			expression.interpret(context);

			assertTrue(TestUtils.equalsForm(context, "<INPUT type=\"text\" name=\"name0\" value=\"v0v\" />"));
	}
}
