/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import junit.framework.TestCase;

public class PropertyCounterTest extends TestCase {
	
	public void testNormal(){
		final PropertyCounter counter = new PropertyCounter();
		assertEquals(0, counter.getCount("id"));
		assertEquals(0, counter.getCount());
		assertNull(counter.getName());
		assertNull(counter.getValue());
		
		assertEquals(1, counter.put("id", "name0"));

		assertEquals(1, counter.getCount("name0"));
		assertEquals(1, counter.getCount());
		assertEquals("id", counter.getName());
		assertEquals("name0", counter.getValue());
		
		assertEquals(2, counter.put("id", "name0"));

		assertEquals(2, counter.getCount("name0"));
		assertEquals(2, counter.getCount());
		assertEquals("id", counter.getName());
		assertEquals("name0", counter.getValue());
		
		assertEquals(1, counter.put("id", "name1"));

		assertEquals(1, counter.getCount("name1"));
		assertEquals(1, counter.getCount());
		assertEquals("id", counter.getName());
		assertEquals("name1", counter.getValue());
		
		assertEquals(2, counter.getCount("name0"));
	}
}
