/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.io.StringWriter;

import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import junit.framework.TestCase;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.test.TestUtils;

public class XmlTransformerFactorySemaphoreTest extends TestCase {
	
	public void testConctractor(){
		try{
			new XmlTransformerFactorySemaphoreImpl(null, 1);
		}catch(final NullPointerException e){
		}
		try{
			new XmlTransformerFactorySemaphoreImpl(new XmlTransformerFactoryImpl(), 0);
		}catch(final IllegalArgumentException e){
		}
	}
	
	public void testNormal(){
		final DomExpression expression = TestUtils.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"value0\" />");
		final DomContext context = new DomContext();
		expression.interpret(context);
		
		final StringWriter w = new StringWriter();
		UtilsConstants.TRANSFORMER_FACTORY.newInstance().transform(
				new DOMSource(context.getNode()), 
				new StreamResult(w)
		);
		assertEquals("<HTML>\n<BODY>\n<FORM>\n<INPUT name=\"name0\" type=\"text\" value=\"value0\">\n</FORM>\n</BODY>\n</HTML>\n", w.toString());		
	}
}
