/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils.concurrent;

import java.util.concurrent.Semaphore;

import junit.framework.TestCase;

public class TrySemaphoreTest extends TestCase {

	public void testConstructor(){
		try{
			new TrySemaphore(null);
			fail();
		}catch(final NullPointerException e){
		}
	}
	
	public void testNormal(){
		final Semaphore semaphore = new Semaphore(1);
		final Acquirable acquirable = new TrySemaphore(semaphore);
		assertTrue(acquirable.acquire());
		assertEquals(0, semaphore.availablePermits());
		assertFalse(acquirable.acquire());
		assertEquals(0, semaphore.availablePermits());
		acquirable.release();
		assertEquals(1, semaphore.availablePermits());
		assertTrue(acquirable.acquire());
		assertEquals(0, semaphore.availablePermits());
		acquirable.release();
		assertEquals(1, semaphore.availablePermits());
	}
}
