/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import junit.framework.TestCase;

public class MessageValidatorTest extends TestCase {

	public void testConstructor(){
		try{
			new MessageValidator(null);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new MessageValidator("");
			fail();
		}catch(final StringIndexOutOfBoundsException expected){
		}
	}
	
	public void testNormal(){
		final ValidatorExpression expression = new MessageValidator("message0");
		final SimpleMessageCollector collector = new SimpleMessageCollector();
		final ValidatorContext context = new ValidatorContext();
		context.setCollectable(collector);
		
		context.setTmpKey("key0");
		assertFalse(expression.interpret(context));
		assertEquals(1, collector.getList().size());
		assertEquals("message0", collector.getList().get(0));
	}
}
