/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import junit.framework.TestCase;

public class TmpIndexValidatorTest extends TestCase {

	public void testConstructor(){
		try{
			new TmpIndexValidator(-1, ValidatorConstants.FALSE);
			fail();
		}catch(final IllegalArgumentException expected){
		}
		try{
			new TmpIndexValidator(0, null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testNormal(){
		final CountValidator counter0 = new CountValidator(ValidatorConstants.FALSE);
		final ValidatorExpression expression = new TmpIndexValidator(1, counter0);
		final ValidatorContext context = new ValidatorContext();
		
		assertFalse(expression.interpret(context));
		assertEquals(1, counter0.getCount());
		assertEquals(1, counter0.getContextList().getLast().getTmpIndex());
	}
}
