/*
 * Decompiled with CFR 0.152.
 */
package woolpack.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancer<C, R>
implements Fn<C, R> {
    private final Fn<Object, ? extends Fn<? super C, ? extends R>> factory;
    private final int length;
    private final Semaphore[] semaphoreArray;
    private final List<Fn<? super C, ? extends R>> fnList;
    private int position = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadBalancer(Fn<Object, ? extends Fn<? super C, ? extends R>> factory, int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length must be equals or more than 1 but " + length);
        }
        this.factory = factory;
        this.length = length;
        this.semaphoreArray = new Semaphore[length];
        this.fnList = new ArrayList<Fn<? super C, ? extends R>>(length);
        int i = 0;
        while (i < length) {
            this.semaphoreArray[i] = new Semaphore(1);
            Fn<Object, Fn<Object, Fn<Object, R>>> fn = factory;
            synchronized (fn) {
                this.fnList.add(factory.exec(null));
            }
            ++i;
        }
    }

    @Override
    public R exec(C c) {
        int i = this.position;
        while (true) {
            if (i < this.length) {
                if (this.semaphoreArray[i].tryAcquire()) {
                    try {
                        R r = this.fnList.get(i).exec(c);
                        return r;
                    }
                    finally {
                        this.semaphoreArray[i].release();
                        this.position = (i + 1) % this.length;
                    }
                }
                Thread.yield();
                ++i;
                continue;
            }
            i = 0;
        }
    }

    public int getLength() {
        return this.length;
    }

    public Fn<Object, ? extends Fn<? super C, ? extends R>> getFactory() {
        return this.factory;
    }
}

