/*
 * Decompiled with CFR 0.152.
 */
package woolpack.web;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import woolpack.container.ContainerContext;
import woolpack.container.ContainerUtils;
import woolpack.el.AbstractGettingEL;
import woolpack.el.GettingEL;
import woolpack.factory.ConcurrentMapCache;
import woolpack.factory.FactoryUtils;
import woolpack.factory.MapCache;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.web.WebContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebUtils {
    public static final Fn<WebContext, Map<String, Object>> REQUEST_FN = new Fn<WebContext, Map<String, Object>>(){

        @Override
        public Map<String, Object> exec(WebContext c) {
            return c.getRequest();
        }
    };
    public static final Fn<WebContext, ConcurrentMap<String, Object>> SESSION_FN = new Fn<WebContext, ConcurrentMap<String, Object>>(){

        @Override
        public ConcurrentMap<String, Object> exec(WebContext c) {
            return c.getSession();
        }
    };
    public static final Fn<WebContext, ConcurrentMap<String, Object>> APPLICATION_FN = new Fn<WebContext, ConcurrentMap<String, Object>>(){

        @Override
        public ConcurrentMap<String, Object> exec(WebContext c) {
            return c.getApplication();
        }
    };
    public static final GettingEL REQUEST_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getRequest();
        }
    };
    public static final GettingEL SESSION_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getSession();
        }
    };
    public static final GettingEL APPLICATION_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getApplication();
        }
    };
    public static final Fn<WebContext, Void> CLEAR_SESSION = new Fn<WebContext, Void>(){

        @Override
        public Void exec(WebContext context) {
            context.getSession().clear();
            return null;
        }
    };
    private static final Fn<ContainerContext<WebContext>, String> GET_KEY = new Fn<ContainerContext<WebContext>, String>(){

        @Override
        public String exec(ContainerContext<WebContext> c) {
            return "woolpack.WebUtils." + c.getKey();
        }
    };
    private static final Fn<ContainerContext<WebContext>, WebContext> SUB_CONTEXT = ContainerUtils.getSubContext();
    private static final Fn<ContainerContext<WebContext>, Map<String, Object>> REQUEST_MAP = FnUtils.join(SUB_CONTEXT, REQUEST_FN);
    private static final Fn<ContainerContext<WebContext>, ConcurrentMap<String, Object>> SESSION_MAP = FnUtils.join(SUB_CONTEXT, SESSION_FN);
    private static final Fn<ContainerContext<WebContext>, ConcurrentMap<String, Object>> APPLICATION_MAP = FnUtils.join(SUB_CONTEXT, APPLICATION_FN);

    private WebUtils() {
    }

    public static <C extends ContainerContext<WebContext>> MapCache<C, String> request(Fn<? super C, ?> fn) {
        return FactoryUtils.cache(REQUEST_MAP, GET_KEY, fn);
    }

    public static <C extends ContainerContext<WebContext>> ConcurrentMapCache<C, String> session(Fn<? super C, ?> fn) {
        return FactoryUtils.concurrentCache(SESSION_MAP, GET_KEY, fn);
    }

    public static <C extends ContainerContext<WebContext>> ConcurrentMapCache<C, String> application(Fn<? super C, ?> fn) {
        return FactoryUtils.concurrentCache(APPLICATION_MAP, GET_KEY, fn);
    }
}

