/*
 * Decompiled with CFR 0.152.
 */
package woolpack.xml;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.fn.Fn;
import woolpack.fn.NullFn;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildElementInserter<C extends NodeContext>
implements Fn<C, Void> {
    private String elementName;
    private Fn<? super C, Void> fn;

    public ChildElementInserter(String elementName, Fn<? super C, Void> fn) {
        this.elementName = elementName;
        this.fn = fn;
    }

    public ChildElementInserter(String elementName) {
        this(elementName, new NullFn());
    }

    @Override
    public Void exec(C c) {
        Node base = c.getNode();
        Element element = XmlUtils.getDocumentNode(base).createElement(this.elementName);
        Node child = null;
        while ((child = base.getFirstChild()) != null) {
            element.appendChild(child);
        }
        base.appendChild(element);
        try {
            c.setNode(element);
            this.fn.exec(c);
        }
        finally {
            c.setNode(base);
        }
        return null;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public Fn<? super C, Void> getFn() {
        return this.fn;
    }

    public void setFn(Fn<? super C, Void> fn) {
        this.fn = fn;
    }
}

