/*
 * Decompiled with CFR 0.152.
 */
package woolpack.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import woolpack.fn.Fn;
import woolpack.xml.XmlTransformerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFactory
implements Fn<String, Node> {
    private Fn<? super String, ? extends Reader> readerFactory;
    private Fn<XmlTransformerContext, Void> transformer;

    public NodeFactory(Fn<? super String, ? extends Reader> readerFactory, Fn<XmlTransformerContext, Void> transformer) {
        this.readerFactory = readerFactory;
        this.transformer = transformer;
    }

    @Override
    public Node exec(String c) {
        DOMResult result = new DOMResult();
        Reader r = this.readerFactory.exec(c);
        if (r == null) {
            throw new IllegalStateException(new FileNotFoundException("not found : " + c));
        }
        try {
            XmlTransformerContext context = new XmlTransformerContext();
            context.setSource(new StreamSource(r));
            context.setResult(result);
            this.transformer.exec(context);
            Node node = result.getNode();
            return node;
        }
        finally {
            try {
                r.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public Fn<? super String, ? extends Reader> getReaderFactory() {
        return this.readerFactory;
    }

    public void setReaderFactory(Fn<? super String, ? extends Reader> readerFactory) {
        this.readerFactory = readerFactory;
    }

    public Fn<XmlTransformerContext, Void> getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Fn<XmlTransformerContext, Void> transformer) {
        this.transformer = transformer;
    }
}

