/*
 * Decompiled with CFR 0.152.
 */
package woolpack.xml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import woolpack.fn.Fn;
import woolpack.xml.NodeFindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFindableChildNodesImpl
implements NodeFindable {
    private Fn<Node, Boolean> nodeChecker;
    private boolean deepFlag;

    public NodeFindableChildNodesImpl(Fn<Node, Boolean> nodeChecker, boolean deepFlag) {
        this.nodeChecker = nodeChecker;
        this.deepFlag = deepFlag;
    }

    @Override
    public NodeList evaluateList(Object node) {
        final ArrayList<Node> list = new ArrayList<Node>();
        this.findNode(list, (Node)node, false);
        return new NodeList(){

            public int getLength() {
                return list.size();
            }

            public Node item(int i) {
                return (Node)list.get(i);
            }
        };
    }

    @Override
    public Node evaluateOne(Object node) {
        ArrayList<Node> list = new ArrayList<Node>(1);
        try {
            this.findNode(list, (Node)node, true);
        }
        catch (IllegalStateException e) {
            if ("node found.".equals(e.getMessage())) {
                return (Node)list.get(0);
            }
            throw e;
        }
        return null;
    }

    private void findNode(List<Node> list, Node base, boolean oneFlag) {
        if (this.nodeChecker.exec(base).booleanValue()) {
            list.add(base);
            if (oneFlag) {
                throw new IllegalStateException("node found.");
            }
            if (!this.deepFlag) {
                return;
            }
        }
        NodeList nodeList = base.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            this.findNode(list, nodeList.item(i), oneFlag);
            ++i;
        }
    }

    public boolean isDeepFlag() {
        return this.deepFlag;
    }

    public void setDeepFlag(boolean deepFlag) {
        this.deepFlag = deepFlag;
    }

    public Fn<Node, Boolean> getNodeChecker() {
        return this.nodeChecker;
    }

    public void setNodeChecker(Fn<Node, Boolean> nodeChecker) {
        this.nodeChecker = nodeChecker;
    }
}

