/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.acquirable;

import java.util.concurrent.Semaphore;

import woolpack.fn.Fn;

/**
 * {@link DoSemaphore}のファクトリです。
 * 
 * @author nakamura
 * 
 */
public class DoSemaphoreFactory implements Fn<Object, DoSemaphore> {
	private int permit;
	private boolean fair;

	/**
	 * @param permit 初期パーミット数。
	 * @param fair フェアなセマフォを作成する場合は true。
	 */
	public DoSemaphoreFactory(final int permit, final boolean fair) {
		this.permit = permit;
		this.fair = fair;
	}

	public DoSemaphore exec(final Object c) {
		return new DoSemaphore(new Semaphore(permit, fair));
	}

	public boolean isFair() {
		return fair;
	}
	public void setFair(final boolean fair) {
		this.fair = fair;
	}
	public int getPermit() {
		return permit;
	}
	public void setPermit(final int permit) {
		this.permit = permit;
	}
}
