/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.bool;

import woolpack.fn.Fn;

/**
 * 委譲先を順次呼び出して集計する{@link Fn}です。
 * @author nakamura
 *
 * @param <C>
 */
public class BoolSeq<C> implements Fn<C, Boolean> {
	private BooleanOperator<C> operator;
	private Iterable<? extends Fn<? super C, Boolean>> iterable;
	
	public BoolSeq(
			final BooleanOperator<C> operator,
			final Iterable<? extends Fn<? super C, Boolean>> iterable) {
		this.operator = operator;
		this.iterable = iterable;
	}
	
	/**
	 * {@link AndAnd}を使用します。
	 * @param iterable
	 */
	public BoolSeq(final Iterable<? extends Fn<? super C, Boolean>> iterable) {
		this(new AndAnd<C>(), iterable);
	}

	public Boolean exec(final C c) {
		return operator.exec(c, iterable);
	}
	
	public Iterable<? extends Fn<? super C, Boolean>> getIterable() {
		return iterable;
	}
	public void setIterable(final Iterable<? extends Fn<? super C, Boolean>> iterable) {
		this.iterable = iterable;
	}
	public BooleanOperator<C> getOperator() {
		return operator;
	}
	public void setOperator(final BooleanOperator<C> operator) {
		this.operator = operator;
	}
}
