/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.bool;

import woolpack.fn.Fn;

/**
 * ビット同値演算子の{@link BooleanOperator}です。
 * 検証結果に関わらず全ての委譲先を呼び出します。
 * @author nakamura
 *
 * @param <C>
 */
public class Eq<C> implements BooleanOperator<C> {
	public boolean exec(final C c, final Iterable<? extends Fn<? super C, Boolean>> iterable) {
		boolean trueFlag = true;
		boolean falseFlag = true;
		for (final Fn<? super C, Boolean> e : iterable) {
			final boolean flag = e.exec(c);
			trueFlag &= flag;
			falseFlag &= !flag;
		}
		return trueFlag || falseFlag;
	}
}
