/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.convert;

import java.text.Format;

import woolpack.fn.Fn;

/**
 * {@link Format}の新規のインスタンスを{@link Format#clone()}により複製するファクトリです。
 * {@link java.text.Format}の各サブクラスはスレッドセーフでなく
 * {@link java.lang.Cloneable}を実装して Prototype デザインパターンを適用していますが、
 * 本クラスはこれを Abstract Factory デザインパターンに変換しています。
 * <br/>適用しているデザインパターン：Prototype, Abstract Factory。
 * @author nakamura
 *
 */
public class CloneFormatFactory implements Fn<Object, Format> {
	private Format format;
	
	public CloneFormatFactory(final Format format) {
		this.format = format;
	}

	public Format exec(final Object c) {
		return (Format) format.clone();
	}

	public Format getFormat() {
		return format;
	}
	public void setFormat(final Format format) {
		this.format = format;
	}
}
