/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.convert;

import java.text.Format;
import java.util.Collection;
import java.util.regex.Pattern;

import woolpack.fn.Fn;

/**
 * ユーティリティです。
 * 型推論で表記を簡略するためのスタティックメソッドと変数を含みます。
 * 
 * @author nakamura
 *
 */
public final class ConvertUtils {

	public static final ToBigDecimalConverter TO_BIG_DECIMAL = new ToBigDecimalConverter();
	public static final ToBigIntegerConverter TO_BIG_INTEGER = new ToBigIntegerConverter();
	public static final ToByteConverter TO_BYTE = new ToByteConverter();
	public static final ToDoubleConverter TO_DOUBLE = new ToDoubleConverter();
	public static final ToFloatConverter TO_FLOAT = new ToFloatConverter();
	public static final ToIntegerConverter TO_INTEGER = new ToIntegerConverter();
	public static final ToLongConverter TO_LONG = new ToLongConverter();
	public static final ToShortConverter TO_SHORT = new ToShortConverter();
	public static final ToSqlDateConverter TO_SQL_DATE = new ToSqlDateConverter();
	public static final ToTimestampConverter TO_TIMESTAMP = new ToTimestampConverter();
	public static final ToStringConverter TO_STRING = new ToStringConverter();
	
	private ConvertUtils() {
	}
	
	public static <K> KeySetGetter<K> keySet() {
		return new KeySetGetter<K>();
	}
	
	public static CloneFormatFactory formatFactory(final Format format) {
		return new CloneFormatFactory(format);
	}
	
	public static FormatConverter format(final Fn<?, Format> formatFactory) {
		return new FormatConverter(formatFactory);
	}
	
	public static NetMaskConverter netMask(final String netMask) {
		return new NetMaskConverter(netMask);
	}
	
	public static ParseConverter parse(final Fn<?, Format> formatFactory) {
		return new ParseConverter(formatFactory);
	}
	
	public static RegExpConverter convertRegExp(
			final Pattern pattern,
			final String replacement) {
		return new RegExpConverter(pattern, replacement);
	}
	
	public static <C, R> TrysFn<C, R> trys(final Iterable<? extends Fn<? super C, ? extends R>> iterable) {
		return new TrysFn<C, R>(iterable);
	}
	
	public static RetainKeys retainKeys(final Collection<?> collection) {
		return new RetainKeys(collection);
	}
}
