/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

/**
 * 値取得と値格納と作用のための式言語を表します。
 * 
 * @author nakamura
 * 
 */
public interface EL extends GettingEL {

	/**
	 * 基点に対し処理を作用させ、値を設定します。
	 * 
	 * @param root 基点。
	 * @param value 実行結果の値。
	 */
	void setValue(Object root, Object value);
}
