/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

/**
 * 値取得と作用のための式言語を表します。
 * 
 * @author nakamura
 * 
 */
public interface GettingEL {

	/**
	 * 基点に対し処理を作用させ、結果を変換して返します。
	 * 
	 * @param root 基点。
	 * @param toType 変換先の型。実装ではこのパラメータが動作に反映されない可能性があります。
	 * @return 実行結果の値。
	 */
	Object getValue(Object root, Class toType);

	/**
	 * 基点に対し処理を作用させ、結果を返します。
	 * 
	 * @param root 基点。
	 * @return 実行結果の値。
	 */
	Object getValue(Object root);
}
