/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import woolpack.fn.Fn;
import woolpack.xml.NodeContext;

/**
 * 指定された DOM ノードを削除し、さらにその後ろにあるテキストノードを全て削除する{@link Fn}です。
 * @author nakamura
 *
 */
public class ThisAndTextsRemover implements Fn<NodeContext, Void> {
	public Void exec(final NodeContext context) {
		HtmlUtils.removeThisAndText(context.getNode());
		return null;
	}
}
