/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.id;

import woolpack.fn.Fn;

/**
 * ユーティリティです。
 * 型推論で表記を簡略するためのスタティックメソッドと変数を含みます。
 * 
 * @author nakamura
 *
 */
public final class IdUtils {
	
	public static final IdGetter GET_ID = new IdGetter();
	
	private IdUtils() {
	}
	
	public static <R> IdConverter<R> convertId(final Fn<? super String, String> fn) {
		return new IdConverter<R>(fn);
	}
	
	public static <C extends IdContext, R> LocalId<C, R> localId(final Fn<? super C, ? extends R> fn) {
		return new LocalId<C, R>(fn);
	}
}
