/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.typeconvert;

import woolpack.fn.Fn;

/**
 * 変換前の値が null であるか、
 * または変換前の値の型が変換後の型と等しいか、
 * または変換後の型が{@link Object}または null の場合は変換前の値を返し、
 * それ以外の場合は委譲する{@link Fn}です。
 * 
 * @author nakamura
 * 
 */
public class DelegationIfNecessityConverter implements Fn<ConvertContext, Void> {
	private Fn<ConvertContext, Void> fn;

	public DelegationIfNecessityConverter(final Fn<ConvertContext, Void> fn) {
		this.fn = fn;
	}

	public Void exec(final ConvertContext c) {
		if (c.getValue() == null
				|| c.getToType() == null
				|| c.getValue().getClass().equals(c.getToType())
				|| Object.class.equals(c.getToType())) {
			// nothing to do.
		} else {
			fn.exec(c);
		}
		return null;
	}

	public Fn<ConvertContext, Void> getFn() {
		return fn;
	}
	public void setFn(final Fn<ConvertContext, Void> fn) {
		this.fn = fn;
	}
}
