/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.visitor;

import java.util.Map;

import woolpack.fn.Fn;

/**
 * 複合体を一段階分解した値を引数にして
 * {@link Visitor#visit(Object)}に委譲する{@link Fn}です。
 * このクラスは LSP(The Liskov Substitution Principle) を満たしません。
 * @author nakamura
 *
 */
public class ComplexAcceptor implements Fn<Visitor<?>, Void> {
	public Void exec(final Visitor<?> visitor) {
		final Object object = visitor.getElement();
		if (object instanceof Map) {
			VisitorUtils.MAP_ACCEPTOR.exec(visitor);
		} else if (object instanceof Iterable) {
			VisitorUtils.ITERABLE_ACCEPTOR.exec(visitor);
		} else if (object.getClass().isArray()) {
			VisitorUtils.ARRAY_ACCEPTOR.exec(visitor);
		} else {
			VisitorUtils.BEAN_ACCEPTOR.exec(visitor);
		}
		return null;
	}
}
