/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.container;

import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.utils.BuildableHashMap;
import woolpack.utils.Utils;

public class ContainerUtilsTest extends TestCase {
	public void testNormal() {
		final ContainerContext<Object> context = new ContainerContext<Object>();
		context.setFn(FnUtils.exec(FnUtils.join(
				ContainerUtils.GET_KEY,
				FnUtils.switching(
						new BuildableHashMap<Object, Fn<? super ContainerContext<Object>, ?>>()
						.map("key0", FnUtils.fix("value0"))
						.map("key1", FnUtils.fix("value1"))
						.map("key2", new Fn<ContainerContext<Object>, Object>() {
							public Object exec(final ContainerContext<Object> c) {
								final Map<String, Object> map = new HashMap<String, Object>();
								map.put("myKey0", c.visit("key0"));
								map.put("myKey1", c.visit("key1"));
								return map;
							}
						})
				))));
		assertEquals("value0", context.visit("key0"));
		assertEquals("value1", context.visit("key1"));
		assertEquals(Utils.map("myKey0", "value0").map("myKey1", "value1"), context.visit("key2"));
	}
}
