/*
 * Decompiled with CFR 0.152.
 */
package woolpack.idnode;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import woolpack.bool.BoolUtils;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.id.IdContext;
import woolpack.xml.NodeContext;
import woolpack.xml.NodeFindUtils;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IFrameInserter<C extends NodeContext & IdContext, E extends Exception>
implements Fn<C, Void, E> {
    private static final Fn<Node, NodeList, RuntimeException> IFRAME = NodeFindUtils.list(FnUtils.join(XmlUtils.GET_NODE_NAME, BoolUtils.checkEquals("IFRAME")), false);
    private static final Fn<Node, Node, RuntimeException> BODY = NodeFindUtils.one(FnUtils.join(XmlUtils.GET_NODE_NAME, BoolUtils.checkEquals("BODY")));
    private static final Fn<Node, Node, RuntimeException> HEAD = NodeFindUtils.one(FnUtils.join(XmlUtils.GET_NODE_NAME, BoolUtils.checkEquals("HEAD")));
    private String frameId;
    private String targetName;
    private Fn<? super C, Void, ? extends E> nodeMaker;
    private Fn<String, String, ? extends E> idConverter;

    public IFrameInserter(String frameId, String targetName, Fn<? super C, Void, ? extends E> nodeMaker, Fn<String, String, ? extends E> idConverter) {
        this.frameId = frameId;
        this.targetName = targetName;
        this.nodeMaker = nodeMaker;
        this.idConverter = idConverter;
    }

    private Node getNode(String id, C c) throws E {
        String baseId = c.getId();
        Node baseNode = c.getNode();
        try {
            c.setId(id);
            this.nodeMaker.exec(c);
            Node node = c.getNode();
            return node;
        }
        finally {
            c.setId(baseId);
            c.setNode(baseNode);
        }
    }

    private static void importNode(Node node0, Node node1) {
        node0.getParentNode().insertBefore(XmlUtils.getDocumentNode(node0).importNode(node1, true), node0);
    }

    @Override
    public Void exec(C c) throws E {
        Node node0 = this.getNode(this.frameId, c);
        NodeList node0IframeList = IFRAME.exec(node0);
        int i = 0;
        while (i < node0IframeList.getLength()) {
            Element node0Iframe = (Element)node0IframeList.item(i);
            boolean targetFlag = this.targetName.equals(node0Iframe.getAttribute("name"));
            Node node1 = this.getNode(targetFlag ? c.getId() : this.idConverter.exec(node0Iframe.getAttribute("src")), c);
            Node node1Body = BODY.exec(node1);
            Node tmp1 = node1Body.getFirstChild();
            while (tmp1 != null) {
                IFrameInserter.importNode(node0Iframe, tmp1);
                tmp1 = tmp1.getNextSibling();
            }
            XmlUtils.removeThis(node0Iframe);
            if (targetFlag) {
                Node node0Head = HEAD.exec(node0);
                IFrameInserter.importNode(node0Head, HEAD.exec(node1));
                XmlUtils.removeThis(node0Head);
            }
            ++i;
        }
        c.setNode(node0);
        return null;
    }

    public String getFrameId() {
        return this.frameId;
    }

    public void setFrameId(String frameId) {
        this.frameId = frameId;
    }

    public Fn<String, String, ? extends E> getIdConverter() {
        return this.idConverter;
    }

    public void setIdConverter(Fn<String, String, ? extends E> idConverter) {
        this.idConverter = idConverter;
    }

    public Fn<? super C, Void, ? extends E> getNodeMaker() {
        return this.nodeMaker;
    }

    public void setNodeMaker(Fn<? super C, Void, ? extends E> nodeMaker) {
        this.nodeMaker = nodeMaker;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }
}

