/*
 * Decompiled with CFR 0.152.
 */
package woolpack.typeconvert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.regex.Pattern;
import woolpack.bool.BoolUtils;
import woolpack.convert.ConvertUtils;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.typeconvert.BeanMap;
import woolpack.typeconvert.ConvertContext;
import woolpack.typeconvert.Converter;
import woolpack.typeconvert.DelegationIfNecessityConverter;
import woolpack.typeconvert.PropertyNameGetter;
import woolpack.typeconvert.RuntimeExceptionToNullConverter;
import woolpack.typeconvert.SettingFnConverter;
import woolpack.typeconvert.ToArrayConverter;
import woolpack.typeconvert.ToBeanConverter;
import woolpack.typeconvert.ToCollectionDecompositionConverter;
import woolpack.typeconvert.ToCollectionViewConverter;
import woolpack.typeconvert.ToMapViewConverter;
import woolpack.typeconvert.ToPrimitiveConverter;
import woolpack.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeConvertUtils {
    public static final Fn<ConvertContext, Class, RuntimeException> GET_TO_TYPE = new Fn<ConvertContext, Class, RuntimeException>(){

        @Override
        public Class exec(ConvertContext c) {
            return c.getToType();
        }
    };
    public static final Fn<ConvertContext, Class, RuntimeException> GET_FROM_TYPE = new Fn<ConvertContext, Class, RuntimeException>(){

        @Override
        public Class exec(ConvertContext c) {
            return c.getValue().getClass();
        }
    };
    public static final Fn<ConvertContext, String, RuntimeException> GET_PROPERTY_NAME = new PropertyNameGetter();
    public static final Fn<ConvertContext, Void, RuntimeException> DATE_FORMATTER = FnUtils.exec(FnUtils.join(GET_PROPERTY_NAME, FnUtils.ifElse((Map)Utils.linkedMap(BoolUtils.ifTrue(BoolUtils.not(BoolUtils.IS_NULL), BoolUtils.checkRegExp(Pattern.compile("^.*date_?time$", 2))), TypeConvertUtils.format(new SimpleDateFormat("yyyyMMddHHmmss"))).map(BoolUtils.ifTrue(BoolUtils.not(BoolUtils.IS_NULL), BoolUtils.checkRegExp(Pattern.compile("^.*time$", 2))), TypeConvertUtils.format(new SimpleDateFormat("HHmmss"))), FnUtils.fix(TypeConvertUtils.format(new SimpleDateFormat("yyyyMMdd"))))));
    public static final Fn<ConvertContext, Void, RuntimeException> DATE_PARSER = new Converter(FnUtils.join(ConvertUtils.TO_STRING, ConvertUtils.trys((Iterable)Utils.list(TypeConvertUtils.parse(new SimpleDateFormat("yyyy-MM-dd"))).list(TypeConvertUtils.parse(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"))).list(TypeConvertUtils.parse(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z"))).list(TypeConvertUtils.parse(new SimpleDateFormat("yyyyMMddHHmmss"))).list(TypeConvertUtils.parse(new SimpleDateFormat("yyyyMMdd"))).list(TypeConvertUtils.parse(DateFormat.getDateInstance(3))).list(TypeConvertUtils.parse(DateFormat.getDateInstance(2))).list(TypeConvertUtils.parse(DateFormat.getDateTimeInstance(2, 2))).list(TypeConvertUtils.parse(DateFormat.getTimeInstance(2))).list(TypeConvertUtils.parse(DateFormat.getDateInstance(1))).list(TypeConvertUtils.parse(DateFormat.getDateTimeInstance(1, 1))).list(TypeConvertUtils.parse(DateFormat.getTimeInstance(1))).list(TypeConvertUtils.parse(DateFormat.getDateTimeInstance(3, 3))).list(TypeConvertUtils.parse(DateFormat.getTimeInstance(3))).list(TypeConvertUtils.parse(DateFormat.getDateInstance(0))).list(TypeConvertUtils.parse(DateFormat.getDateTimeInstance(0, 0))).list(TypeConvertUtils.parse(DateFormat.getTimeInstance(0))), FnUtils.fixThrows(null), new Fn<Exception, Void, RuntimeException>(){

        @Override
        public Void exec(Exception c) {
            throw new IllegalArgumentException(c);
        }
    })));
    public static final Fn<ConvertContext, Void, RuntimeException> NUMBER_FORMATTER = new Converter(ConvertUtils.format(ConvertUtils.formatFactory(new DecimalFormat())));
    public static final Fn<ConvertContext, Void, RuntimeException> NUMBER_PARSER = new Converter(FnUtils.join(ConvertUtils.TO_STRING, ConvertUtils.trys((Iterable)Utils.list(TypeConvertUtils.parse(new DecimalFormat())), FnUtils.fixThrows(null), new Fn<Exception, Void, RuntimeException>(){

        @Override
        public Void exec(Exception c) {
            throw new IllegalArgumentException(c);
        }
    })));
    public static final Fn<ConvertContext, Void, RuntimeException> SIMPLE_CONVERTER = TypeConvertUtils.getSimpleConverter(DATE_FORMATTER, DATE_PARSER, NUMBER_FORMATTER, NUMBER_PARSER, BoolUtils.TO_BOOLEAN_VIEW, FnUtils.fix(null));
    public static final Fn<ConvertContext, Void, RuntimeException> COLLECTION_CONVERTER = TypeConvertUtils.getCollectionConverter(DATE_FORMATTER, DATE_PARSER, NUMBER_FORMATTER, NUMBER_PARSER, BoolUtils.TO_BOOLEAN_VIEW);

    private TypeConvertUtils() {
    }

    private static Fn<String, Object, Exception> parse(Format f) {
        return ConvertUtils.parse(ConvertUtils.formatFactory(f));
    }

    private static Fn<ConvertContext, Void, RuntimeException> format(Format f) {
        return new Converter(ConvertUtils.format(ConvertUtils.formatFactory(f)));
    }

    private static Fn<ConvertContext, Void, RuntimeException> getToDateAndAfter(final Fn<ConvertContext, Void, RuntimeException> successorFn, final Fn<Object, ?, RuntimeException> afterConverter) {
        return new Fn<ConvertContext, Void, RuntimeException>(){

            @Override
            public Void exec(ConvertContext c) throws RuntimeException {
                Object mid;
                Object before = c.getValue();
                if (before instanceof java.util.Date) {
                    mid = before;
                } else if (before instanceof Calendar) {
                    mid = afterConverter.exec(new java.util.Date(((Calendar)before).getTimeInMillis()));
                } else if (before instanceof Long) {
                    mid = new java.util.Date((Long)before);
                } else {
                    successorFn.exec(c);
                    mid = c.getValue();
                }
                c.setValue(afterConverter.exec(mid));
                return null;
            }
        };
    }

    private static void riseCanntConvertDateToNumberException() {
        throw new IllegalArgumentException("cannot convert Date to Number which is not Long.");
    }

    private static Fn<ConvertContext, Void, RuntimeException> getToNumberAndAfter(final Fn<ConvertContext, Void, RuntimeException> successorFn, final Fn<Object, ?, RuntimeException> afterConverter) {
        return new Fn<ConvertContext, Void, RuntimeException>(){

            @Override
            public Void exec(ConvertContext c) throws RuntimeException {
                Object mid;
                Object before = c.getValue();
                if (before instanceof Number) {
                    mid = before;
                } else if (before instanceof Boolean) {
                    mid = (Boolean)before != false ? 1 : 0;
                } else if (before instanceof java.util.Date) {
                    if (!Long.class.equals((Object)c.getToType())) {
                        TypeConvertUtils.riseCanntConvertDateToNumberException();
                    }
                    mid = ((java.util.Date)before).getTime();
                } else if (before instanceof Calendar) {
                    if (!Long.class.equals((Object)c.getToType())) {
                        TypeConvertUtils.riseCanntConvertDateToNumberException();
                    }
                    mid = ((Calendar)before).getTimeInMillis();
                } else {
                    successorFn.exec(c);
                    mid = c.getValue();
                }
                c.setValue(afterConverter.exec(mid));
                return null;
            }
        };
    }

    private static Fn<ConvertContext, Void, RuntimeException> getSimpleConverterPrivate(final Fn<ConvertContext, Void, RuntimeException> dateFormatter, Fn<ConvertContext, Void, RuntimeException> dateParser, final Fn<ConvertContext, Void, RuntimeException> numberFormatter, Fn<ConvertContext, Void, RuntimeException> numberParser, Fn<Object, Boolean, RuntimeException> booleanConverter, Fn<ConvertContext, Void, RuntimeException> successorFn) {
        return FnUtils.exec(FnUtils.join(GET_TO_TYPE, FnUtils.switching((Map)Utils.map(String.class, new Fn<ConvertContext, Void, RuntimeException>(){
            private final Fn<ConvertContext, Void, RuntimeException> defaultConverter = new Converter(ConvertUtils.TO_STRING);

            @Override
            public Void exec(ConvertContext c) {
                if (c.getValue() instanceof java.util.Date) {
                    dateFormatter.exec(c);
                } else if (c.getValue() instanceof Number) {
                    numberFormatter.exec(c);
                } else {
                    this.defaultConverter.exec(c);
                }
                return null;
            }
        }).map(Character.class, (Object)new Converter(new Fn<Object, Character, RuntimeException>(){

            @Override
            public Character exec(Object c) {
                String s = c.toString();
                if (s.length() == 0) {
                    throw new IllegalArgumentException();
                }
                return Character.valueOf(s.charAt(0));
            }
        })).map(Boolean.class, (Object)new Converter(booleanConverter)).map((Class<Boolean>)java.util.Date.class, TypeConvertUtils.getToDateAndAfter(dateParser, FnUtils.echo())).map(Calendar.class, TypeConvertUtils.getToDateAndAfter(dateParser, ConvertUtils.TO_CALENDAR)).map(Date.class, TypeConvertUtils.getToDateAndAfter(dateParser, ConvertUtils.TO_SQL_DATE)).map(Time.class, TypeConvertUtils.getToDateAndAfter(dateParser, ConvertUtils.TO_TIME)).map(Timestamp.class, TypeConvertUtils.getToDateAndAfter(dateParser, ConvertUtils.TO_TIMESTAMP)).map(Byte.class, TypeConvertUtils.getToNumberAndAfter(numberParser, ConvertUtils.TO_BYTE)).map(Short.class, TypeConvertUtils.getToNumberAndAfter(numberParser, ConvertUtils.TO_SHORT)).map(Integer.class, TypeConvertUtils.getToNumberAndAfter(numberParser, ConvertUtils.TO_INTEGER)).map(Long.class, TypeConvertUtils.getToNumberAndAfter(numberParser, ConvertUtils.TO_LONG)).map(Float.class, TypeConvertUtils.getToNumberAndAfter(numberParser, ConvertUtils.TO_FLOAT)).map(Double.class, TypeConvertUtils.getToNumberAndAfter(numberParser, ConvertUtils.TO_DOUBLE)).map(BigInteger.class, TypeConvertUtils.getToNumberAndAfter(numberParser, ConvertUtils.TO_BIG_INTEGER)).map(BigDecimal.class, TypeConvertUtils.getToNumberAndAfter(numberParser, ConvertUtils.TO_BIG_DECIMAL)), successorFn)));
    }

    public static Fn<ConvertContext, Void, RuntimeException> getSimpleConverter(Fn<ConvertContext, Void, RuntimeException> dateFormatter, Fn<ConvertContext, Void, RuntimeException> dateParser, Fn<ConvertContext, Void, RuntimeException> numberFormatter, Fn<ConvertContext, Void, RuntimeException> numberParser, Fn<Object, Boolean, RuntimeException> booleanConverter, Fn<ConvertContext, Void, RuntimeException> successorFn) {
        return new ToPrimitiveConverter(new DelegationIfNecessityConverter((Fn<? super ConvertContext, Void, ? extends RuntimeException>)TypeConvertUtils.getSimpleConverterPrivate(dateFormatter, dateParser, numberFormatter, numberParser, booleanConverter, successorFn)));
    }

    public static Fn<ConvertContext, Void, RuntimeException> getCollectionConverter(Fn<ConvertContext, Void, RuntimeException> dateFormatter, Fn<ConvertContext, Void, RuntimeException> dateParser, Fn<ConvertContext, Void, RuntimeException> numberFormatter, Fn<ConvertContext, Void, RuntimeException> numberParser, Fn<Object, Boolean, RuntimeException> booleanConverter) {
        return new SettingFnConverter(new ToPrimitiveConverter(new RuntimeExceptionToNullConverter(new DelegationIfNecessityConverter(new ToArrayConverter(new ToCollectionViewConverter(new ToCollectionDecompositionConverter(new ToMapViewConverter((Fn<? super ConvertContext, Void, ? extends RuntimeException>)TypeConvertUtils.getSimpleConverterPrivate(dateFormatter, dateParser, numberFormatter, numberParser, booleanConverter, new ToBeanConverter())))))))));
    }

    public static Fn<Object, BeanMap, RuntimeException> toMap() {
        return new Fn<Object, BeanMap, RuntimeException>(){

            @Override
            public BeanMap exec(Object c) {
                return new BeanMap(c);
            }
        };
    }

    public static Fn<Object, BeanMap, RuntimeException> toMap(final Fn<ConvertContext, Void, RuntimeException> fn) {
        return new Fn<Object, BeanMap, RuntimeException>(){

            @Override
            public BeanMap exec(Object c) {
                return new BeanMap(c, fn);
            }
        };
    }
}

