/*
 * Decompiled with CFR 0.152.
 */
package woolpack.web;

import java.util.List;
import java.util.Random;
import woolpack.fn.Fn;
import woolpack.utils.Utils;
import woolpack.web.WebContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionTokenFn<C extends WebContext, R, E extends Exception>
implements Fn<C, R, E> {
    public static final int TOKEN_LENGTH = 32;
    private static final int DEGIT_COUNT = 10;
    private static final int TOKEN_CHAR_COUNT = 36;
    private int size;
    private String key;
    private Fn<? super C, Boolean, ? extends E> targetCheckFn;
    private Fn<? super C, R, ? extends E> trueFn;
    private Fn<? super C, R, ? extends E> falseFn;
    private Random r;

    public TransactionTokenFn(String key, Fn<? super C, Boolean, ? extends E> targetCheckFn, Fn<? super C, R, ? extends E> trueFn, Fn<? super C, R, ? extends E> falseFn, int size) {
        this.key = key;
        this.targetCheckFn = targetCheckFn;
        this.trueFn = trueFn;
        this.falseFn = falseFn;
        this.size = size;
        this.r = new Random();
    }

    @Override
    public R exec(C c) throws E {
        if (this.targetCheckFn.exec(c).booleanValue()) {
            Object oldToken = c.getSession().get(this.key);
            List<?> requestedTokens = Utils.toList(c.getInput().get(this.key));
            String newToken = this.generateToken();
            if (oldToken != null && oldToken.equals(requestedTokens.get(0)) && c.getSession().replace(this.key, oldToken, newToken)) {
                this.trueFn.exec(c);
            } else {
                this.falseFn.exec(c);
            }
        } else {
            String newToken;
            Object oldToken;
            do {
                oldToken = c.getSession().get(this.key);
                newToken = this.generateToken();
            } while (!(oldToken == null ? c.getSession().putIfAbsent(this.key, newToken) == null : c.getSession().replace(this.key, oldToken, newToken)));
            this.trueFn.exec(c);
        }
        return null;
    }

    String generateToken() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.size) {
            int j = this.r.nextInt(36);
            sb.append(j < 10 ? (char)(48 + j) : (char)(65 + j - 10));
            ++i;
        }
        return sb.toString();
    }

    public Fn<? super C, R, ? extends E> getFalseFn() {
        return this.falseFn;
    }

    public void setFalseFn(Fn<? super C, R, ? extends E> falseFn) {
        this.falseFn = falseFn;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Fn<? super C, Boolean, ? extends E> getTargetCheckFn() {
        return this.targetCheckFn;
    }

    public void setTargetCheckFn(Fn<? super C, Boolean, ? extends E> targetCheckFn) {
        this.targetCheckFn = targetCheckFn;
    }

    public Fn<? super C, R, ? extends E> getTrueFn() {
        return this.trueFn;
    }

    public void setTrueFn(Fn<? super C, R, ? extends E> trueFn) {
        this.trueFn = trueFn;
    }
}

