<?php
	$modules = sbm::get_installed_modules();
?>

<p id="module-update-success" class="success"><?php _e('Module\'s options updated'); ?></p>
<p id="module-update-error" class="error"></p>

<p>
	<label for="module-name"><?php _e('Module\'s name'); ?>:</label><br />
	<input id="module-name" name="module_name" type="text" value="<?php echo($module->name); ?>" />
</p>

<p>
	<?php _e('Module\'s type'); ?>:<br />
	<?php echo($modules[$module->type]['name']); ?>
</p>

<p>
	<a id="toggle-advanced-output-options" href="#"><?php _e('Advanced options'); ?></a>
	<div id="advanced-output-options" class="toggle-item">
		<p>
			<input id="output-show-title" name="output[show_title]" type="checkbox"<?php if($module->output['show_title']) { ?> checked="checked"<?php } ?> /> <label for="output-show-title"><?php _e('Show module\'s title'); ?></label>
		</p>

		<p>
			<label for="output-css-file"><?php _e('Related CSS file'); ?>:</label><br />
			<input id="output-css-file" name="output[css_file]" type="text" value="<?php echo($module->output['css_file']); ?>" />
		</p>
	</div>
</p>

<fieldset>
	<legend>Display on:</legend>
	<input id="display-home" name="display[home]" type="checkbox"<?php if($module->display['home']) { ?> checked="checked"<?php } ?> /> <label for="display-home"><?php _e('Homepage'); ?></label><br />

	<input id="display-archives" name="display[archives]" type="checkbox"<?php if($module->display['archives']) { ?> checked="checked"<?php } ?> /> <label for="display-archives"><?php _e('Archives'); ?></label><br />

	<input id="display-post" name="display[post]" type="checkbox"<?php if($module->display['post']) { ?> checked="checked"<?php } ?> /> <label for="display-post"><?php _e('Single posts'); ?></label> &raquo; <a id="toggle-specific-posts" href="#"><?php _e('Detailed options'); ?></a><br />

	<div id="specific-posts" class="toggle-item"></div>

	<input id="display-search" name="display[search]" type="checkbox"<?php if($module->display['search']) { ?> checked="checked"<?php } ?> /> <label for="display-search"><?php _e('Search results'); ?></label><br />

	<input id="display-pages" name="display[pages]" type="checkbox"<?php if($module->display['pages']) { ?> checked="checked"<?php } ?> /> <label for="display-pages"><?php _e('Static pages'); ?></label> &raquo; <a id="toggle-specific-pages" href="#"><?php _e('Detailed options'); ?></a><br />

	<div id="specific-pages" class="toggle-item"></div>

	<input id="display-error" name="display[error]" type="checkbox"<?php if($module->display['error']) { ?> checked="checked"<?php } ?> /> <label for="display-error"><?php _e('Error page'); ?></label>
</fieldset>
