<?php
	$modules = sbm::get_installed_modules();
	$sidebars = sbm::get_sidebars();
?>

<div class="wrap">
	<h2><?php _e('Re-order sidebar modules') ?></h2>

	<div id="sbm-options" class="tab-box right">
		<ul class="tab-bar">
			<li id="show-tab-module-add"><a href="#"><?php _e('Add module'); ?></a></li>
			<li id="show-tab-module-options"><a href="#"><?php _e('Module\'s options'); ?></a></li>
		</ul>

		<div id="tab-module-add" class="tab">
			<h3><?php _e('Add module') ?></h3>

			<form id="module-add">
				<p id="module-add-error" class="error"></p>

				<p>
					<label for="add-name"><?php _e('Module\'s name'); ?>:</label><br />
					<input id="add-name" name="add_name" type="text" />
				</p>

				<p>
					<label for="add-type"><?php _e('Module\'s type'); ?>:</label><br />
					<select id="add-type" name="add_type" size="10">
						<?php $selected = false; foreach($modules as $id => $module): ?>
							<option value="<?php echo($id); ?>"<?php if(!$selected) { ?> selected="selected"<?php $selected = true; } ?>><?php _e($module['name']); ?></option>
						<?php endforeach; ?>
					</select>
				</p>

				<p>
					<label for="add-sidebar"><?php _e('Add to'); ?>:</label><br />
					<select id="add-sidebar" name="add_sidebar">
						<?php $seected = false; foreach($sidebars as $id => $sidebar): ?>
							<option value="<?php echo($id); ?>"<?php if(!$selected) { ?> selected="selected"<?php $selected = true; } ?>><?php _e($sidebar->name); ?></option>
						<?php endforeach; ?>
						<option value="disabled"><?php _e('Disabled modules'); ?></option>
					</select>
				</p>

				<p class="submit">
					<input type="submit" value="Add &raquo;" />
				</p>
			</form>
		</div>

		<div id="tab-module-options" class="tab">
			<h3><?php _e('Module\'s options') ?></h3>

			<div id="module-options">
				<span id="module-options-desc"><?php _e('Select a module to view it\'s options here'); ?></span>

				<form id="module-options-form">
					<div id="module-options-custom">
					</div>

					<p class="submit">
						<input class="remove" type="button" value="Remove &raquo;" /> <input type="submit" value="Save &raquo;" />
					</p>
				</form>
			</div>
		</div>
	</div>

	<div id="sbm-dnd" class="sbm-block">
		<?php foreach(sbm::get_sidebars() as $id => $sidebar): ?>
			<div class="module-list">
				<h4><?php echo($sidebar->name);?></h4>

				<ul id="<?php echo($id); ?>">
				</ul>
			</div>
		<?php endforeach; ?>

		<div class="module-list">
			<h4><?php _e('Disabled modules'); ?></h4>

			<ul id="disabled">
			</ul>
		</div>

		<div class="clear"></div>
	</div>

	<div class="clear"></div>
</div>

<div class="wrap">
	<p style="text-align: center;">A <a href="http://nybblelabs.org.uk/">Ben Sherratt</a> production &middot; <a href="http://nybblelabs.org.uk/contact/">Grab some support</a> &middot; <a href="http://nybblelabs.org.uk/projects/sidebar-modules/#register">Give some support</a></p>
	<p style="text-align: center;"><a href="http://nybblelabs.org.uk/projects/sidebar-modules/"><img alt="Get Modules" src="<?php sbm::output_url(); ?>/images/get-modules.png" /></a></p>
</div>
